/*
 * @(#)OMDependencyFigure.java  1.0  2. Februar 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo.diagram;

import ch.hslu.cm.*;
import ch.hslu.cm.oo.*;
import ch.hslu.cm.simulation.*;
import ch.hslu.cm.oo.objectmodel.*;
import java.io.IOException;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import java.beans.*;
import static org.jhotdraw.draw.AttributeKeys.*;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.decoration.ArrowTip;
/**
 * OMDependencyFigure visually represents a {@link OMDependency}.
 *
 * @author  Werner Randelshofer
 * @version 1.0 2. Februar 2004  Created.
 */
public class OMDependencyFigure extends LineConnectionFigure implements DiagramFigure, PropertyChangeListener {
    private OMDependency model;
    
    /** Creates a new instance. */
    public OMDependencyFigure() {
        END_DECORATION.set(this, new ArrowTip(Math.PI / 6, 12, 0, false, true, false));
        STROKE_DASHES.set(this, new double[] {4d, 2d});
        setModel(new OMDependency());
        
        setAttributeEnabled(END_DECORATION, false);
        setAttributeEnabled(START_DECORATION, false);
        setAttributeEnabled(STROKE_DASHES, false);
    }
    
    public void setModel(OMDependency m) {
        if (model != null) {
            model.removePropertyChangeListener(this);
        }
        model = m;
        if (model != null) {
            model.addPropertyChangeListener(this);
        }
        //updateLabels();
    }
    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        if ((drawing instanceof Diagram) && getModel() != null) {
            getSimulation().add(getModel());
        }
    }
    @Override
    public void removeNotify(Drawing drawing) {
        if (getDrawing() != null && getModel() != null) {
            getSimulation().remove(getModel());
        }
        super.removeNotify(drawing);
    }
    
    @Override
    public OMDependency getModel() {
        return model;
    }
    
    /**
     * Handles the disconnection of a connection.
     * Override this method to handle this event.
     */
    protected void handleDisconnect(Figure start, Figure end) {
        model.setEnd(null);
        model.setStart(null);
    }
    
    /**
     * Handles the connection of a connection.
     * Override this method to handle this event.
     */
    protected void handleConnect(Figure start, Figure end) {
        if ((start instanceof DiagramFigure)
        && (end instanceof DiagramFigure)) {
            DiagramFigure sf = (DiagramFigure) start;
            DiagramFigure ef = (DiagramFigure) end;
            
            model.setEnd((SimulatedElement) ef.getModel());
            model.setStart((SimulatedElement) sf.getModel());
        }
    }
    
    
    private Diagram getDiagram() {
        return (Diagram) getDrawing();
    }
    private Simulation getSimulation() {
        return (getDiagram() == null) ? null : getDiagram().getSimulation();
    }
    
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
    
    @Override
    public OMDependencyFigure clone() {
        OMDependencyFigure that = (OMDependencyFigure) super.clone();
        that.setModel((OMDependency) this.getModel().clone());
        return that;
    }
    
    /**
     * Checks if two figures can be connected. Implement this method
     * to constrain the allowed connections between figures.
     */
    public boolean canConnect(Figure start, Figure end) {
        if ((start instanceof DiagramFigure)
        && (end instanceof DiagramFigure)) {
            
            DiagramFigure sf = (DiagramFigure) start;
            DiagramFigure ef = (DiagramFigure) end;
            
            return model.canConnect(
                    (SimulatedElement) sf.getModel(), 
                    (SimulatedElement) ef.getModel()
                    );
        }
        
        return false;
    }
    public boolean canConnect(Figure start) {
        if (start instanceof DiagramFigure) {
            DiagramFigure sf = (DiagramFigure) start;
            return model.canConnect((SimulatedElement) sf.getModel());
        }
        return false;
    }
    
    public int getConnectionCount() {
        return 0;
    }
    
    public int getConnectionIndex(ConnectionFigure f) {
        return 0;
    }
    
    public int getConnectionIndex(DiagramFigure f) {
        return 0;
    }
    @Override
    public void read(DOMInput in) throws IOException {
        in.openElement((in.getElementCount("model") == 1) ? "model" : "Model");
        setModel((OMDependency) in.readObject(0));
        in.closeElement();
        super.read(in);
    }
    @Override
    public void write(DOMOutput out) throws IOException {
        out.openElement("Model");
        out.writeObject(getModel());
        out.closeElement();
        super.write(out);
    }
    @Override
    public int getLayer() {
        return ClassDiagram.LINK_LAYER;
    }
}
